/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.block;

import com.github.mim1q.convenientdecor.block.blockentity.WateringCanBlockEntity;
import com.github.mim1q.convenientdecor.init.ModItems;
import com.github.mim1q.convenientdecor.item.WateringCanItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WateringCanBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = WateringCanBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");

    public WateringCanBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WateringCanBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, FILLED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean filled = WateringCanItem.getWaterLevel(ctx.m_43722_()) > 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)ctx.m_43722_()) > 0;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(filled));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return WateringCanBlock.getStackFromBlockEntity(world.m_7702_(pos));
    }

    private static ItemStack getStackFromBlockEntity(BlockEntity entity) {
        if (entity instanceof WateringCanBlockEntity) {
            WateringCanBlockEntity wateringCan = (WateringCanBlockEntity)entity;
            ItemStack stack = new ItemStack((ItemLike)ModItems.WATERING_CAN);
            WateringCanItem.setWaterLevel(stack, wateringCan.getWaterLevel());
            if (wateringCan.isInfiniteWater()) {
                stack.m_41663_(Enchantments.f_44952_, 1);
            }
            return stack;
        }
        return null;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(world, player, pos, state, blockEntity, tool);
        if (world.f_46443_) {
            return;
        }
        ItemStack stack = WateringCanBlock.getStackFromBlockEntity(blockEntity);
        if (stack != null) {
            ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            world.m_7967_((Entity)entity);
        }
    }
}

